#!/usr/bin/python
# -*- coding: utf-8 -*-

#import signal
import Pyro.core
import Pyro.naming
from Pyro.errors import NamingError
import optparse
from Leone import *

class LeoneServer(Pyro.core.ObjBase, Leone):

	__daemon = None

	def daemon(self, daemon = None):
		if (daemon != None):
			if (isinstance(daemon, Pyro.core.Daemon) == False):
				raise TypeError, "Il demone deve essere un oggetto di tipo Pyro.core.Daemon"
			self.__daemon = daemon
		return self.__daemon
	
	def __init__(self):
		Pyro.core.ObjBase.__init__(self)

	def setup_remote(self, name):

		pipe = subprocess.Popen("hostname", shell = True, stdout = subprocess.PIPE)
		hn = pipe.stdout.readline().rstrip("\n")
		pipe.stdout.close()
		pipe.terminate()

		Pyro.core.initServer()
		ns=Pyro.naming.NameServerLocator().getNS()
		daemon = self.daemon(Pyro.core.Daemon(host = hn))
		daemon.useNameServer(ns)

		uri = daemon.connect(LeoneServer(), name)
		try:
			daemon.requestLoop()
		finally:
			self.daemon().shutdown(True)

	def init(self, nome, eta, razza):

		Leone.init(self, nome, eta, razza)

if __name__ == "__main__":
	parser = optparse.OptionParser()
	parser.add_option("-n", "--nome", dest="nome", default="leone", help="nome univoco dell'oggetto")
	(options, args) = parser.parse_args()
	nome = options.nome

	leone_remote = LeoneServer()
	leone_remote.setup_remote(nome)
