#!/usr/bin/python
# -*- coding: utf-8 -*-

from time import sleep
from random import random

class Animale(object):

	__nome = ""
	__eta = 0
	__razza = ""
	__spazio_medio = 0.0
	__spazio_totale = 0.0

	def nome(self, nome = None):
		if (nome != None):
			if (isinstance(nome, str) == False):
				raise TypeError, "Il nome deve essere una stringa"
			if (nome == ""):
				raise ValueError, "Il nome deve essere una stringa non vuota"
			self.__nome = nome
		return self.__nome

	def eta(self, eta = None):
		if (eta != None):
			if (isinstance(eta, int) == False):
				raise TypeError, "L'età deve essere un intero"
			if (eta < 0):
				raise ValueError, "L'età deve essere un intero non negativo"
			self.__eta = eta
		return self.__eta

	def razza(self, razza = None):
		if (razza != None):
			if (isinstance(razza, str) == False):
				raise TypeError, "La razza deve essere una stringa"
			if (razza == ""):
				raise ValueError, "La razza deve essere una stringa non vuota"
			self.__razza = razza
		return self.__razza

	def spazio_medio(self, spazio_medio = None):
		if (spazio_medio != None):
			if (isinstance(spazio_medio, float) == False):
				raise TypeError, "Lo spazio medio percorso deve essere un float"
			if (spazio_medio < 0):
				raise ValueError, "Lo spazio medio percorso deve essere un float non negativo"
			self.__spazio_medio = spazio_medio
		return self.__spazio_medio

	def spazio_totale(self, spazio_totale = None):
		if (spazio_totale != None):
			if (isinstance(spazio_totale, float) == False):
				raise TypeError, "Lo spazio totale percorso deve essere un float"
			if (spazio_totale < 0):
				raise ValueError, "Lo spazio totale percorso deve essere un float non negativo"
			self.__spazio_totale = spazio_totale
		return self.__spazio_totale

	def __init__(self, nome, eta, razza):
		self.nome(nome)
		self.eta(eta)
		self.razza(razza)
		self.spazio_medio(0.0)
		self.spazio_totale(0.0)

	def parla(self, tempo):
		raise RuntimeError, "il metodo parla() non è implementato nella classe Animale"

	def muove(self, tempo):
		raise RuntimeError, "il metodo muove() non è implementato nella classe Animale"

	def mangia(self, tempo):
		raise RuntimeError, "il metodo mangia() non è implementato nella classe Animale"

	def beve(self, tempo):
		raise RuntimeError, "il metodo beve() non è implementato nella classe Animale"

	def dorme(self, tempo):
		if (isinstance(tempo, float) == False):
			raise TypeError, "Il tempo trascorso deve essere un float"
		if (tempo < 0.0):
			raise ValueError, "Il tempo trascorso deve essere un float non negativo"
		t = int(random() * 5 + 1)
		sleep(t)

		return "ha dormito per " + str(t) + " unità di tempo"
