#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import re
import optparse
import numpy as np
import matplotlib.pyplot as plt

parser = optparse.OptionParser("usage: %prog [options]")
parser.add_option("-l", "--log", dest="log", \
			default="zoo.log", type="string", \
			help="file di log di zoo.py")
parser.add_option("-o", "--output", dest="output", \
			default="grafico", type="string", \
			help="prefisso dei file destinazione")
(options, args) = parser.parse_args()

log = options.log
output = options.output

temp = []

try:
	fh = open(log, "r")
	temp = fh.readlines()
except IOError:
	print "Non sono riuscito ad aprire " \
		+ log + " in lettura."
	sys.exit(1)
finally:
	fh.close()

# Considera le righe di livello INFO contenenti la stringa "metri"
# ed intercetta il nome dell'animale e lo spazio percorso
regex = re.compile(r'^.*level:INFO Tempo=(\d+) ID=([^\s]+) (\w+).*metri \(a (\d+\.\d{0,3}).*$')

# temp = [...] -> temp è un array
# (m.group(2), m.group(1), m.group(3)) ... if m -> torna una tupla (tempo, nome,
#                                                  spazio medio percorso) se
#                                                  l'oggetto m è definito
# for l in temp -> cicla su tutte le righe di temp di livello INFO e
#                  contenenti la stringa "metri"
# for m in [regex.search(l)] -> per ciascuna riga l, cicla su tutti i
#                               possibili match. Per come è fatto il log,
#                               esiste un solo match. Ritorna l'oggetto m
#                               contenente il match.
temp = [ (m.group(1), m.group(2), m.group(3), m.group(4)) for l in temp for m in [regex.search(l)] if m]
d = dict()
for t, i, n, s in temp:
	d.setdefault(i, []).append((n, t, s))
for k in d.keys():
	nome = d[k][0][0]
	x_axis = np.array([t[1] for t in d[k]])
	y_axis = np.array([t[2] for t in d[k]]) 	
	plt.figure()
	plt.plot(x_axis, y_axis, "b-", linewidth=2)
	plt.plot(x_axis, y_axis, "ro", linewidth=2)
	plt.xlabel('Tempo(s)')
	plt.ylabel('Velocità(metri/secondo)')
	plt.title('Percorso medio di ' + nome)
	plt.grid(True)
	plt.savefig(output + "_" + k)
