#!/usr/bin/python
# -*- coding: utf-8 -*-

import signal
import ZooAlgo
import ZooGUI
import Queue
import optparse

signal.signal(signal.SIGINT, signal.SIG_DFL) # ^C termina l'applicazione

parser = optparse.OptionParser()
parser.add_option("-c", "--config", dest = "config", type = "string", default = "zoo.ini")
(options, args) = parser.parse_args()
config = options.config

queue = Queue.Queue()
zoo = ZooAlgo.ZooAlgo(config, queue)
zoo.start()
zoo_gui = ZooGUI.ZooGUI("zoo.glade", zoo, queue)
