#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import sys
from time import sleep
from random import random, shuffle
import threading
from inspect import currentframe, getframeinfo
import Pyro.core
import Pyro.util
import ConfigParser
import Logger

class ZooAlgo(threading.Thread):

	__zoo = []
	__animali = []
	__azioni = []
	__intervallo = 1
	__server = []
	__ns = ""
	__server_path = ""
	__config = None
	__logger = None
	__riproduci = False
	__inuscita = False
	__queue = None
	__tempo_trascorso = 0

	# Impostazione di metodi getter/setter per gli
	# elementi della classe tramite le property
	# http://adam.gomaa.us/blog/2008/aug/11/the-python-property-builtin/

	@property
	def zoo(self):
		"""Un array contenente gli animali dello zoo"""
		return self.__zoo

	@zoo.setter
	def zoo(self, zoo_array):
		self.__zoo = zoo_array

	@property
	def animali(self):
		"""Un array contenente i tipi di animali"""
		return self.__animali

	@animali.setter
	def animali(self, animali_array):
		self.__animali = animali_array

	@property
	def azioni(self):
		"""Un array contenente le azioni degli animali"""
		return self.__azioni

	@azioni.setter
	def azioni(self, azioni_array):
		self.__azioni = azioni_array

	@property
	def intervallo(self):
		"""Un intero contenente l'intervallo di campionamento"""
		return self.__intervallo

	@intervallo.setter
	def intervallo(self, intervallo_int):
		self.__intervallo = intervallo_int

	@property
	def server(self):
		"""Un array contenente i nomi dei nodi server"""
		return self.__server

	@server.setter
	def server(self, server_array):
		self.__server = server_array

	@property
	def ns(self):
		"""Una stringa contenente il nome dell'object name server"""
		return self.__ns

	@ns.setter
	def ns(self, ns_str):
		self.__ns = ns_str

	@property
	def server_path(self):
		"""Una stringa contenente il percorso degli object server"""
		return self.__server_path

	@server_path.setter
	def server_path(self, server_path_str):
		self.__server_path = server_path_str

	@property
	def config(self):
		"""Configurazione dello zoo (oggetto ConfigParser)"""
		return self.__config

	@config.setter
	def config(self, config_obj):
		self.__config = config_obj

	@property
	def logger(self):
		"""Logger dell'applicazione (oggetto logging)"""
		return self.__logger

	@logger.setter
	def logger(self, logger_obj):
		self.__logger = logger_obj

	@property
	def riproduci(self):
		"""Flag per la riproduzione dei messaggi."""
		return self.__riproduci

	@riproduci.setter
	def riproduci(self, riproduci_bool):
		self.__riproduci = riproduci_bool

	@property
	def inuscita(self):
		"""Flag per la segnalazione dell'uscita."""
		return self.__inuscita

	@inuscita.setter
	def inuscita(self, inuscita_bool):
		self.__inuscita = inuscita_bool

	@property
	def queue(self):
		"""Coda per la comunicazione con la GUI (oggetto Queue)."""
		return self.__queue

	@queue.setter
	def queue(self, queue_obj):
		self.__queue = queue_obj

	@property
	def tempo_trascorso(self):
		"""Tempo trascorso (secondi)."""
		return self.__tempo_trascorso

	@tempo_trascorso.setter
	def tempo_trascorso(self, tempo_trascorso_int):
		self.__tempo_trascorso = tempo_trascorso_int

	# Costruttore dello zoo
	# - legge la configurazione
	# - attiva il logger
	# - inizializza l'array zoo contenente gli animali
	def __init__(self, filename, queue):
		threading.Thread.__init__(self)
		Pyro.core.initClient()
		self.setup_zoo(filename, queue)

	def setup_zoo(self, filename, queue):
		if os.path.isfile(filename) == False:
			print "Non sono riuscito ad aprire il file %s" % filename
			sys.exit(1)
		self.zero_config()
		self.config = self.read_config(filename)
		self.logger = self.fire_logger(self.config)
		self.queue = queue
		self.setup_pyro()
		sleep(3)
		self.build_zoo()

	def zero_config(self):
		self.zoo = []
		self.animali = []
		self.azioni = []
		self.server = []
		self.ns = ""
		self.intervallo = 1
		self.config = None

	def read_config(self, filename):

		Config = ConfigParser.ConfigParser()
		Config.read(filename)
		self.config = Config
		return Config

	def fire_logger(self, Config):

		logger_name = Config.get("Zoo", "LogFile")

		logger = Logger.Logger()
		logger.setup(logger_name)
		return logger

	def caso(self, numero):
		if numero == None:
			numero = 1
		return (int( random() * numero ))

	def build_zoo(self):

		contatore = 1
		self.azioni = self.config.get("Zoo", "Azioni").split(",")
		self.animali = self.config.get("Zoo", "Animali").split(",")
		self.intervallo = int(self.config.get("Zoo", "Sleep"))
		nomi = dict()
		razze = dict()
		maxnum = dict()
		num = dict()
		maxeta = dict()

		for a in self.animali:
			exec_str = "import " + a + "Client"
			exec(exec_str)
			nomi[a] = self.config.get(a, "Nomi").split(",")
			razze[a] = self.config.get(a, "Razze").split(",")
			maxnum[a] = int(self.config.get(a, "MaxNum"))
			num[a] = self.caso(maxnum[a]) + 1
			maxeta[a] = int(self.config.get(a, "MaxEta"))

		for a in self.animali:
			n = num[a]
			for b in range(n):
				# Genera le caratteristiche della bestia
				nome_bestia = nomi[a][self.caso(len(nomi[a]))]
				nome_remoto_bestia = nome_bestia + "-" + str(contatore)
				eta_bestia = self.caso(maxeta[a]) + 1
				razza_bestia = razze[a][self.caso(len(razze[a]))]
				contatore = contatore + 1

				# Genera l'oggetto remoto
				srv = self.server[self.caso(len(self.server))]
					
				os.system("ssh " + srv + " " + self.server_path + "/" \
					+ a + "Server.py -n " + nome_remoto_bestia + " &")
				sleep(1)

				# Genera il proxy locale
				eval_str = a + "Client." + a + "Client(nome_remoto_bestia)"
				ok = False
				while (ok == False):
					try:
						bestia_client = eval(eval_str)
					except:
						self.logger.log_info("Errore di connessione - nuovo tentativo in 1s")
						sleep(1)
						ok = False
					else:
						ok = True
				eval_str = "bestia_client.dyn_proxy().init(nome_bestia, eta_bestia, razza_bestia)"
				eval(eval_str)
				self.zoo.append(bestia_client)
		shuffle(self.zoo)

	def simula(self):

		id_zoo = self.caso(len(self.zoo))
		id_azione = self.caso(len(self.azioni))
		bestia = self.zoo[id_zoo]

		self.logger.log_debug( \
			"Generati id_zoo=%(id_zoo)d, id_azione=%(id_azione)d, " \
			"bestia=%(bestia)s" % \
			{
				"id_zoo": id_zoo,
				"id_azione": id_azione,
				"bestia": bestia.dyn_proxy().nome()
			}
		)

		return (bestia, id_azione)

	def build_output(self, bestia, azione, tempo_trascorso):

		frase = "Tempo=" + str(tempo_trascorso) + " "

		frase = frase + "ID=" + bestia.nome() + " "
		frase = frase + bestia.dyn_proxy().nome() + " "
		frase = frase + "(età "
		frase = frase + str(bestia.dyn_proxy().eta())
		frase = frase + " anni, razza "
		frase = frase + str(bestia.dyn_proxy().razza())
		frase = frase + ") "

		ptr_azione = getattr(bestia.dyn_proxy(), self.azioni[azione])
		print frase, self.azioni[azione]
		frase = frase + ptr_azione(tempo_trascorso)
		return frase

	# Ciclo di riproduzione (fatto tramite thread)
	def run(self):
		while self.inuscita == False:
			if (self.riproduci == True):
				bestia, id_azione = self.simula()
				self.tempo_trascorso += self.intervallo
				msg = self.build_output(bestia, id_azione, self.tempo_trascorso)
				self.queue.put(msg)
				self.logger.log_info(msg)
			sleep(self.intervallo)

	def setup_pyro(self):
		self.server = self.config.get("Remote", "Server").split(",")
		self.ns = self.config.get("Remote", "NS")
		self.server_path = self.config.get("Remote", "ServerPath")

		os.system("ssh " + self.ns + " pyro-ns -n " + self.ns + " &")

	def cleanup_pyro(self):
		for s in self.server:
			obj_srv_str = ""
			for a in self.animali:
				obj_srv_str = obj_srv_str + a + "Server.py "
			os.system("ssh " + s + " killall " + obj_srv_str)
		os.system("ssh " + self.ns + " kill -15 \$\(pgrep -f Pyro.naming\)")
