#!/usr/bin/python

import optparse
import signal
import Queue
import threading
import logging

import ParseImages
import DownloadImages

logging.basicConfig(level=logging.INFO, \
        format='(%(threadName)-10s) %(message)s', \
)

parser = optparse.OptionParser()
parser.add_option("-n", "--num-threads", dest = "num_threads", type = "int", \
	default = 2, \
	help = "The number of parallel image downloaders")
parser.add_option("-u", "--url", dest = "url", \
	default = "http://www.repubblica.it", \
	help = "The URL to be scraped")
parser.add_option("-o", "--output-dir", dest = "output_dir", \
	default = "prova", \
	help = "The output directory")
parser.add_option("-v", "--verbose", dest = "verbose", action = "store_true", \
	help = "Be verbose")
parser.add_option("-q", "--quiet", dest = "verbose", action = "store_false", \
	help = "Be quiet")

(options, args) = parser.parse_args()

url = options.url
output_dir = options.output_dir
num_threads = options.num_threads
verbose = options.verbose

# Restore default SIGINT behavior
signal.signal(signal.SIGINT, signal.SIG_DFL)

# Create instance of communication queue
queue = Queue.Queue()

# Create instance of HTML parser
imageParser = ParseImages.ParseImages(url = url, queue = queue, verbose = verbose)

# Parse the image sources
try:
	imageParser.parse()
except:
	pass

#Create instances of downloaders
for i in range(num_threads):
	worker = DownloadImages.DownloadImages(args = (queue, "prova", verbose,))
	worker.setDaemon(True)
	worker.start()

queue.join()
imageParser.close()
