#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
try:  
	import pygtk  
	pygtk.require("2.0")  
except:  
	pass  
try:  
	import gtk  
	import gtk.glade  
except:  
	print("GTK non disponibile")
	sys.exit(1)
import gobject
import signal
import Queue
import Producer
import time

class ThreadGUI:

	__wTree = None
	__timer_id = None
	__producer = None

	# Impostazione di metodi getter/setter per gli
	# elementi della classe tramite le property
	# http://adam.gomaa.us/blog/2008/aug/11/the-python-property-builtin/
	@property
	def wTree(self):
		"""Gerarchia delle finestre (oggetto gtk.glade.XML)"""
		return self.__wTree

	@wTree.setter
	def wTree(self, wTree_obj):
		self.__wTree = wTree_obj

	@property
	def queue(self):
		"""Coda per la comunicazione con la GUI (oggetto Queue)."""
		return self.__queue

	@queue.setter
	def queue(self, queue_obj):
		self.__queue = queue_obj

	@property
	def producer(self):
		"""Classe produttrice."""
		return self.__producer

	@producer.setter
	def producer(self, producer_obj):
		self.__producer = producer_obj

	def __init__(self, queue, producer):

		gtk.gdk.threads_init()

		self.queue = queue
		self.producer = producer
		self.wTree = gtk.glade.XML( "ThreadGUI.glade" )

		dic = {
			"on_windowMain_destroy" : self.quit
		}
		self.wTree.signal_autoconnect( dic )

		self.producer.start()
		self.__timer_id = gobject.timeout_add( \
			1000, self.aggiorna_window)
		gtk.main()

	def aggiorna_window(self):
		if self.queue.empty() == False:
			msg = self.queue.get()
			textviewOutput = self.wTree.get_widget("textviewOutput")
			textviewOutput.get_buffer().insert( \
				textviewOutput.get_buffer().get_end_iter(), \
				"\n" + msg)
		return True

	def quit(self, widget):
		self.producer.finished = True
		gobject.source_remove(self.__timer_id)		
		gtk.main_quit()

if __name__ == "__main__":
	signal.signal(signal.SIGINT, signal.SIG_DFL)
	queue = Queue.Queue()
	producer = Producer.Producer(args = (queue,))
	gui = ThreadGUI(queue, producer)
