import logging
import Queue
import threading
import urllib2

class DownloadImages(threading.Thread):

	__queue = None
	__output_dir = ""
	__verbose = False

	@property
	def queue(self):
		"""Coda di comunicazione"""
		return self.__queue

	@queue.setter
	def queue(self, queue_obj):
		self.__queue = queue_obj

	@property
	def output_dir(self):
		"""Directory di download delle immagini"""
		return self.__output_dir

	@output_dir.setter
	def output_dir(self, output_dir_str):
		self.__output_dir = output_dir_str

	@property
	def verbose(self):
		"""Output verboso"""
		return self.__verbose

	@verbose.setter
	def verbose(self, verbose_flag):
		self.__verbose = verbose_flag

	def __init__(self, group=None, target=None, name=None, \
		args=(), verbose=None):
		(self.queue, self.output_dir, self.verbose) = args

		threading.Thread.__init__(self, group=group, target=target, \
			name=name, verbose=verbose)
		return

	def run(self):
		while True:
			url = self.queue.get()
			if self.verbose == True:
				logging.info("Extracting URL from queue: %s" % url)
			try:
				if self.verbose == True:
					logging.info("Reading from URL %s" % url)
				u = urllib2.urlopen(url)
			except urllib2.HTTPError:
				logging.info("Could not open URL %s" % url)
			else:
				data = u.read()
				splitPath = url.split('/')
				fName = self.output_dir + "/" + splitPath.pop()
				if self.verbose == True:
					logging.info("Saving file %s in %s" \
						% (fName, self.output_dir))
				try:
					f = open(fName, 'wb')
					f.write(data)
					f.close()
				except IOError:
					logging.info("Could not open file %s" % fName)
			finally:
				self.queue.task_done()
