#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
try:  
	import pygtk  
	pygtk.require("2.0")  
except:  
	pass  
try:  
	import gtk  
	import gtk.glade  
except:  
	print("GTK non disponibile")
	sys.exit(1)
import gobject
import ZooAlgo
from time import sleep
#from random import random, shuffle
#from inspect import currentframe, getframeinfo
#import ConfigParser
#import Logger

#from Animale import *
#from Cane import *
#from Cavallo import *
#from Leone import *

class ZooGUI:

	__wTree = None
	__ZooAlgo = None
	__timer_id = None

	# Impostazione di metodi getter/setter per gli
	# elementi della classe tramite le property
	# http://adam.gomaa.us/blog/2008/aug/11/the-python-property-builtin/
	@property
	def wTree(self):
		"""Gerarchia delle finestre (oggetto gtk.glade.XML)"""
		return self.__wTree

	@wTree.setter
	def wTree(self, wTree_obj):
		self.__wTree = wTree_obj

	@property
	def ZooAlgo(self):
		"""Lo zoo virtuale (oggetto ZooAlgo)."""
		return self.__ZooAlgo

	@ZooAlgo.setter
	def ZooAlgo(self, ZooAlgo_obj):
		self.__ZooAlgo = ZooAlgo_obj

	@property
	def queue(self):
		"""Coda per la comunicazione con la GUI (oggetto Queue)."""
		return self.__queue

	@queue.setter
	def queue(self, queue_obj):
		self.__queue = queue_obj

	def __init__(self, filename, zoo_algo, queue):

		gtk.gdk.threads_init()

		self.ZooAlgo = zoo_algo
		self.queue = queue
		self.wTree = gtk.glade.XML( filename )

		dic = {
			"on_filechooserbutton_file_set" : self.aggiorna_config,
			"on_entryIntvl_changed": self.aggiorna_intervallo,
			"on_buttonPlay_clicked" : self.play,
			"on_buttonStop_clicked" : self.stop,
			"on_buttonQuit_clicked" : self.quit,
			"on_windowMain_destroy" : self.quit
		}
		self.wTree.signal_autoconnect( dic )
		self.wTree.get_widget("entryIntvl").set_text( \
			str(self.ZooAlgo.intervallo))

		self.__timer_id = gobject.timeout_add( \
			self.ZooAlgo.intervallo * 1000, \
			self.aggiorna_window)
		gtk.main()

	def aggiorna_intervallo(self, widget):
		if self.__timer_id != None:
			gobject.source_remove(self.__timer_id)
		text = widget.get_text()
		if text != '':
			self.__timer_id = gobject.timeout_add( \
				self.ZooAlgo.intervallo * 1000, \
				self.aggiorna_window)
			self.ZooAlgo.intervallo = int(widget.get_text())
			self.ZooAlgo.riproduci = True
		else:
			self.ZooAlgo.riproduci = False

	def aggiorna_config(self, widget):
		self.ZooAlgo.riproduci = False
		while self.queue.empty() != True:
			sleep(self.ZooAlgo.intervallo)
		self.ZooAlgo.zero_config()
		self.ZooAlgo.setup_zoo(widget.get_filename(), self.queue)
		self.ZooAlgo.riproduci = True

	def aggiorna_window(self):
		if self.queue.empty() == False:
			msg = self.queue.get()
			textviewOutput = self.wTree.get_widget("textviewOutput")
			textviewOutput.get_buffer().insert( \
				textviewOutput.get_buffer().get_end_iter(), \
				"\n" + msg)
		return True
		
	def play(self, widget):
		self.ZooAlgo.riproduci = True

	def stop(self, widget):
		self.ZooAlgo.riproduci = False

	def quit(self, widget):
		self.stop(widget)
		self.ZooAlgo.inuscita = True
		self.ZooAlgo.join()
		gobject.source_remove(self.__timer_id)
		gtk.main_quit()
