#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import sys
from time import sleep
from random import random, shuffle
import threading
from inspect import currentframe, getframeinfo
import ConfigParser
import Logger

from Animale import *
from Cane import *
from Cavallo import *
from Leone import *

class ZooAlgo(threading.Thread):

	__zoo = []
	__azioni = []
	__intervallo = 1
	__config = None
	__logger = None
	__riproduci = False
	__inuscita = False
	__queue = None

	# Impostazione di metodi getter/setter per gli
	# elementi della classe tramite le property
	# http://adam.gomaa.us/blog/2008/aug/11/the-python-property-builtin/

	@property
	def zoo(self):
		"""Un array contenente gli animali dello zoo"""
		return self.__zoo

	@zoo.setter
	def zoo(self, zoo_array):
		self.__zoo = zoo_array

	@property
	def azioni(self):
		"""Un array contenente le azioni degli animali"""
		return self.__azioni

	@azioni.setter
	def azioni(self, azioni_array):
		self.__azioni = azioni_array

	@property
	def intervallo(self):
		"""Un intero contenente l'intervallo di campionamento"""
		return self.__intervallo

	@intervallo.setter
	def intervallo(self, intervallo_int):
		self.__intervallo = intervallo_int

	@property
	def config(self):
		"""Configurazione dello zoo (oggetto ConfigParser)"""
		return self.__config

	@config.setter
	def config(self, config_obj):
		self.__config = config_obj

	@property
	def logger(self):
		"""Logger dell'applicazione (oggetto logging)"""
		return self.__logger

	@logger.setter
	def logger(self, logger_obj):
		self.__logger = logger_obj

	@property
	def riproduci(self):
		"""Flag per la riproduzione dei messaggi."""
		return self.__riproduci

	@riproduci.setter
	def riproduci(self, riproduci_bool):
		self.__riproduci = riproduci_bool

	@property
	def inuscita(self):
		"""Flag per la segnalazione dell'uscita."""
		return self.__inuscita

	@inuscita.setter
	def inuscita(self, inuscita_bool):
		self.__inuscita = inuscita_bool

	@property
	def queue(self):
		"""Coda per la comunicazione con la GUI (oggetto Queue)."""
		return self.__queue

	@queue.setter
	def queue(self, queue_obj):
		self.__queue = queue_obj

	# Costruttore dello zoo
	# - legge la configurazione
	# - attiva il logger
	# - inizializza l'array zoo contenente gli animali
	def __init__(self, filename, queue):
		threading.Thread.__init__(self)
		self.setup_zoo(filename, queue)

	def setup_zoo(self, filename, queue):
		if os.path.isfile(filename) == False:
			print "Non sono riuscito ad aprire il file %s" % filename
			sys.exit(1)
		self.zero_config()
		self.config = self.read_config(filename)
		self.logger = self.fire_logger(self.config)
		self.queue = queue
		self.build_zoo()

	def zero_config(self):
		self.zoo = []
		self.azioni = []
		self.intervallo = 1
		self.config = None
		self.logger = None
		self.queue = None

	def read_config(self, filename):

		Config = ConfigParser.ConfigParser()
		Config.read(filename)
		return Config

	def fire_logger(self, Config):

		logger_name = Config.get("Zoo", "LogFile")

		logger = Logger.Logger()
		logger.setup(logger_name)
		return logger

	def caso(self, numero):
		if numero == None:
			numero = 1
		return (int( random() * numero ))

	def build_zoo(self):

		self.azioni = self.config.get("Zoo", "Azioni").split(",")
		self.intervallo = int(self.config.get("Zoo", "Sleep"))

		nomi = dict()
		razze = dict()
		maxnum = dict()
		num = dict()
		maxeta = dict()
		animali = self.config.get("Zoo", "Animali").split(",")


		for a in animali:
			nomi[a] = self.config.get(a, "Nomi").split(",")
			razze[a] = self.config.get(a, "Razze").split(",")
			maxnum[a] = int(self.config.get(a, "MaxNum"))
			num[a] = self.caso(maxnum[a]) + 1
			maxeta[a] = int(self.config.get(a, "MaxEta"))

		for a in animali:
			n = num[a]
			for b in range(n):
				eval_str = "self.zoo.append(" + a + "(nome = \"" + \
					nomi[a][self.caso(len(nomi[a]))] + "\", " + \
					"eta = " + str(self.caso(maxeta[a]) + 1) + \
					", logger = self.logger, razza = \"" + \
					razze[a][self.caso(len(razze[a]))] + "\"))"
				eval(eval_str)

		shuffle(self.zoo)

	def simula(self):

		id_zoo = self.caso(len(self.zoo))
		id_azione = self.caso(len(self.azioni))
		bestia = self.zoo[id_zoo]

		self.logger.log_debug( \
			"Generati id_zoo=%(id_zoo)d, id_azione=%(id_azione)d, " \
			"bestia=%(bestia)s" % \
			{
				"id_zoo": id_zoo,
				"id_azione": id_azione,
				"bestia": bestia.nome()
			}
		)

		return (bestia, id_azione)

	def build_output(self, bestia, azione):

		frase = ""
		
		frase = bestia.nome()
		frase = frase + " (età "
		frase = frase + str(bestia.eta())
		frase = frase + " anni, razza "
		frase = frase + bestia.razza()
		frase = frase + ") "

		ptr_azione = getattr(bestia, self.azioni[azione])
		frase = frase + ptr_azione()

		return frase

	# Ciclo di riproduzione (fatto tramite thread)
	def run(self):
		while self.inuscita == False:
			if (self.riproduci == True):
				bestia, id_azione = self.simula()
				msg = self.build_output(bestia, id_azione)
				self.queue.put(msg)
				self.logger.log_info(msg)
			sleep(self.intervallo)
