#!/usr/bin/python

import logging
import random
import threading
import time

logging.basicConfig(level=logging.DEBUG, \
	format='%(asctime)s (%(threadName)-2s) %(message)s', \
)

class ActivePool(object):
	def __init__(self):
		super(ActivePool, self).__init__()
		self.active = []
		self.lock = threading.Lock()
	def makeActive(self, name):
		self.lock.acquire()
		self.active.append(name)
		logging.debug('Running: %s', self.active)
		self.lock.release()
	def makeInactive(self, name):
		self.lock.acquire()
		self.active.remove(name)
		logging.debug('Running: %s', self.active)
		self.lock.release()

def worker(s, pool):
	logging.debug('Waiting to join the pool')
	s.acquire()
	name = threading.currentThread().getName()
	pool.makeActive(name)
	time.sleep(0.1)
	pool.makeInactive(name)
	s.release()

pool = ActivePool()
s = threading.Semaphore(2)
for i in range(4):
	t = threading.Thread(target=worker, name=str(i), args=(s, pool))
	t.start()
