#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
try:  
	import pygtk  
	pygtk.require("2.0")  
except:  
	pass  
try:  
	import gtk  
	import gtk.glade  
except:  
	print("GTK non disponibile")
	sys.exit(1)
import ZooAlgo
from time import sleep
#from random import random, shuffle
#from inspect import currentframe, getframeinfo
#import ConfigParser
#import Logger

#from Animale import *
#from Cane import *
#from Cavallo import *
#from Leone import *

class ZooGUI:

	__wTree = None
	__ZooAlgo = None

	# Impostazione di metodi getter/setter per gli
	# elementi della classe tramite le property
	# http://adam.gomaa.us/blog/2008/aug/11/the-python-property-builtin/
	@property
	def wTree(self):
		"""Gerarchia delle finestre (oggetto gtk.glade.XML)"""
		return self.__wTree

	@wTree.setter
	def wTree(self, wTree_obj):
		self.__wTree = wTree_obj

	@property
	def ZooAlgo(self):
		"""Lo zoo virtuale (oggetto ZooAlgo)."""
		return self.__ZooAlgo

	@ZooAlgo.setter
	def ZooAlgo(self, ZooAlgo_obj):
		self.__ZooAlgo = ZooAlgo_obj

	def __init__(self, filename, zoo_algo):

		self.ZooAlgo = zoo_algo
		self.wTree = gtk.glade.XML( filename )
		dic = {
			"on_buttonSimula_clicked" : self.simula,
			"on_filechooserbutton_file_set" : self.aggiorna_config,
			"on_buttonQuit_clicked" : self.quit,
			"on_windowMain_destroy" : self.quit
		}

		self.wTree.signal_autoconnect( dic )
		gtk.main()

	def aggiorna_config(self, widget):
		self.ZooAlgo.zero_config()
		self.ZooAlgo.setup_zoo(widget.get_filename())

	def simula(self, widget):

		bestia, id_azione = self.ZooAlgo.simula()
		msg = self.ZooAlgo.build_output(bestia, id_azione)
		textviewOutput = self.wTree.get_widget("textviewOutput")
		textviewOutput.get_buffer().insert( \
			textviewOutput.get_buffer().get_end_iter(), \
			"\n" + msg)
		self.ZooAlgo.logger.log_info(msg)

	def quit(self, widget):
		sys.exit(0)
