#!/usr/bin/python
# -*- coding: utf-8 -*-

import logging
import inspect

class Logger():

	def __init__(self):
		self.__log = None
		self.__sh = None
		self.__lf = None

	def setup(self, filename):
		self.__log = logging.getLogger(filename)
		self.__log.setLevel(logging.DEBUG)
		self.__sh = logging.FileHandler(filename, "a")
		self.__lf = logging.Formatter( \
			"%(asctime)s level:%(levelname)s %(message)s" \
		)
		self.__sh.setFormatter(self.__lf)
		self.__log.addHandler(self.__sh)

	def log_info(self, message):
		self.__log.info(message)

	def log_debug(self, message):
		stack = inspect.stack()
		buffer = "filename:%(filename)s function:%(function)s " \
			"line:%(lineno)d " % \
			{
				"filename": stack[1][1],
				"function": stack[1][3],
				"lineno": stack[1][2]
			}
		#print "buffer: ", buffer
		#print "message: ", message
		buffer = buffer + message

		self.__log.debug(buffer)
