#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
import sys

class Parser:

	D = dict()

	def __init__(self):
		pass

	def get_D(self):
		return self.D

	# Una piccola avvertenza. Per file di log
	# veramente grandi, non è consigliabile
	# la lettura di tutte le righe tramite il
	# metodo readlines() (si rischia di far
	# paginare il SO). È preferibile leggere
	# e scandire una riga alla volta.
	def readlog(self, filename):

		temp = []

		try:
			fh = open(filename, "r")
			temp = fh.readlines()
		except IOError:
			print "Non sono riuscito ad aprire " \
				+ filename + " in lettura."
			sys.exit(1)
		finally:
			fh.close()

		# Rimuove i commenti
		temp = [ l.split("#")[0] for l in temp ]

		# Rimuove le righe vuote
		temp = [ l for l in temp if l.strip() ]

		return temp

	def parselog(self, buffers):

		regexp = re.compile(r"""
			(?P<istante>[^\s]+)	# primo parametro
			\s+			# spazi a piacere
			(?P<nome>[^\s]+)	# secondo parametro
			\s+			# spazi a piacere
			(?P<classe>[^\s]+)	# terzo parametro
			\s+			# spazi a piacere
			(?P<azione>[^\s]+)	# quarto parametro
			(
			\s+			# spazi a piacere
			(?P<argomento>[^\s]+)	# quinto parametro
			)?			# se esiste
			""", re.VERBOSE)
		for l in buffers:

			t = 0
			d = dict()

			srch = regexp.search(l)
			d = srch.groupdict()

			try:
				t = float(d["istante"])
			except ValueError:
				print "Riga ", l
				print "L'istante ", d["istante"] \
					, " non è un float"
				sys.exit(1)

			if d["argomento"] == None:
				del d["argomento"]			
			else:
				try:
					t = float(d["argomento"])
				except ValueError:
					print "Riga ", l
					print "L'argomento " \
						, d["argomento"] \
						, " non è un float"
					sys.exit(1)

			del d["istante"]
			self.D[str(t)] = d

if __name__ == "__main__":
	parser = Parser()
	parser.parselog(parser.readlog("log.txt"))
	print parser.get_D()
