#!/usr/bin/python
# coding: utf-8

# Equivalente dello switch statement tramite funzioni lambda.
# Si consideri:
# x = 10
# y = 'a'
# switch(y) {
#     case 'a': x = x * 5;
#     case 'b': x = x + 7;
#     case 'c': x = x - 2;
# }
#
# Costruiamo una espressione equivalente usando le funzioni lambda.
#
# L'espressione:
# {
#	'a': lambda x: x * 5,
#	'b': lambda x: x + 7,
#	'c': lambda x: x - 2
# }
# è un dizionario che mappa valori diversi a funzioni lambda diverse.
# L'espressione:
# {
#	'a': lambda x: x * 5,
#	'b': lambda x: x + 7,
#	'c': lambda x: x - 2
# }['a']
# rappresenta il valore del dizionario relativo alla chiave 'a', ossia
# la funzione lambda x: x * 5.
# L'espressione:
# {
#	'a': lambda x: x * 5,
#	'b': lambda x: x + 7,
#	'c': lambda x: x - 2
# }['a'](10)
# rappresenta la funziona lambda x: x * 5 valutata in x = 10. Il risultato
# dell'espressione è 50.

result = {
	'a': lambda x: x * 5,
	'b': lambda x: x + 7,
	'c': lambda x: x - 2
}['a'](10)
print result

