#!/usr/bin/python
# -*- coding: utf-8 -*-

from time import sleep
from random import random

class Animale:

	def __init__(self, nome, eta):
		self.__nome = nome
		self.__eta = eta

	def parla(self):
		raise RuntimeError, "il metodo parla() non è implementato nella classe Animale"

	def muove(self):
		raise RuntimeError, "il metodo muove() non è implementato nella classe Animale"

	def mangia(self):
		raise RuntimeError, "il metodo mangia() non è implementato nella classe Animale"

	def beve(self):
		raise RuntimeError, "il metodo beve() non è implementato nella classe Animale"

	def dorme(self):
		t = int(random() * 5 + 1)
		sleep(t)
		return "ha dormito per " + str(t) + " unità di tempo"

	def nome(self, nome = None):
		if (nome != None):
			if (isinstance(nome, str) == False):
				raise TypeError, "il nome deve essere una stringa"
			if (nome == ""):
				raise ValueError, "il nome deve essere una stringa non vuota"
			self.__nome = nome
		return self.__nome

	def eta(self, eta = None):
		if (eta != None):
			if (isinstance(eta, int) == False):
				raise TypeError, "l'età deve essere un intero"
			if (eta < 0):
				raise ValueError, "l'età deve essere un intero non negativo"
			self.__eta = eta
		return self.__eta
