#!/usr/bin/python
# coding=utf8

'''
Created on 25/apr/2011

@author: giacomo
'''


# importiamo funzioni utili
##from time import sleep
from random import random, shuffle, randrange, Random
import pickle

# importiamo le classi
from Animale import *
from Cane import *
from Cavallo import *
from Leone import *

# funzione per restituire un intero casuale
def caso(periodo):
    if periodo == None:
        periodo = 1
    return (int( random() * periodo ))

# lista degli animali
zoo = []

# possibili nomi degli animali
nomi_cani = [ "Lessie", "Rocky", "Laika", "Poldo", "Fuffi" ]
nomi_cavalli = [ "Varenne", "Freccia", "Spirit", "Stella", "Strike" ]
nomi_leoni = [ "Leo", "Leonida", "Principessa", "Leone", "Re", "Simba" ]

# possibili caratteristiche degli animanli
razze_cani = [ "pastore", "levriero", "maremmano", "schnauzer", "barboncino" ]
mantelli_cavalli = [ "nero", "baio", "pezzato", "fulvo" ]
pesi_leoni = range(150,225)

# numero di animali
num_cani = randrange(1,10)
num_cavalli = randrange(1,10)
num_leoni = randrange(1,10)

# eta' massime
max_eta_cane = 20
max_eta_cavallo = 25
max_eta_leone = 20

# crea un oggetto Random (serve per choice
r = Random()

# crea i cani
for i in range(num_cani):
    zoo.append(
        Cane(
            nome = r.choice(nomi_cani),
            eta = randrange(1,max_eta_cane),
            razza = r.choice(razze_cani)
        )
    )

# crea i cavalli
for i in range(num_cavalli):
    zoo.append(
        Cavallo(
            nome = r.choice(nomi_cavalli),
            eta = randrange(1,max_eta_cavallo),
            mantello = r.choice(mantelli_cavalli)
        )
    )

# crea i leoni
for i in range(num_leoni):
    zoo.append(
        Leone(
            nome = r.choice(nomi_leoni),
            eta = randrange(1,max_eta_leone),
            peso = r.choice(pesi_leoni)
        )
    )

# mischia tutti gli animali
shuffle(zoo)

# apre il file zoo.dat in scrittura
f = None
try:
    f = open("zoo.dat", "w")
except IOError, error:
    print "Impossibile aprire il file zoo.dat:",error
    quit()

# memorizza tutti gli animali
for a in zoo:
    pickle.dump(a,f)
f.close()

# apre il file zoo.dat in lettura
f = None
try:
    f = open("zoo.dat", "r")
except IOError, error:
    print "Impossibile aprire il file zoo.dat:",error
    quit()

# lettura dei singoli oggetti
fine = False
while not fine:
    try:
        o = pickle.load(f)
        print "Letto:",o
    # si ferma quando raggiunge EOF
    except EOFError, error:
        fine = True
    except IOError, error:
        print "Impossibile leggere dal file zoo.dat:",error
        fine = True
f.close()

# apre il file zoo_all.dat in scrittura
f = None
try:
    f = open("zoo_all.dat", "w")
except IOError, error:
    print "Impossibile aprire il file zoo_all.dat:",error
    quit()

# memorizza l'array con tutti gli animali
pickle.dump(zoo,f)
f.close()

# apre il file zoo_all.dat in lettura
f = None
try:
    f = open("zoo_all.dat", "r")
except IOError, error:
    print "Impossibile aprire il file zoo_all.dat:",error
    quit()

# lettura dell'array
try:
    all = pickle.load(f)
    print "Letto:",all
except IOError, error:
        print "Impossibile leggere dal file zoo_all.dat:",error

f.close()