"""
Created on 24/apr/2011

@author: giacomo
"""

class Lista(object):
    """
    classe che implemeta una lista a riferimenti
    """
    
    # NOTA: non viene verificata l'esistenza di elementi/coda
    # nei metodi head e tail

    def __init__(self):
        """
        Costruttore
        """
        # node e' il primo nodo della lista
        # all'inizio la lista e' vuota
        self.node = None
        
    def isEmpty(self):
        """
        Dice se la lista e' vuota
        """
        # la lista e' vuota se node non contiene niente
        return (self.node == None)
    
    def cons(self, val):
        """
        Aggiunge val all'inizio della lista 
        """
        # il nuovo primo nodo e' una coppia costituita da:
        # - il nuovo valore
        # - il vecchio primo nodo
        self.node = [val, self.node]
        
    def head(self):
        """
        Restituisce il primo elemento della lista
        """
        return self.node[0]
    
    def tail(self):
        """
        Restituisce la lista senza il primo elemento
        """
        tmp = Lista()
        
        # con condivisione della struttura
        #tmp.node = self.node[1]
        
        # per non avere structure sharing:
        # creo un array
        x = []
        l_tmp = self.node
        # inserisco tutti gli elementi della lista nell'array
        while l_tmp != None:
            x.append(l_tmp[0])
            l_tmp = l_tmp[1]
        # elimino il primo elemento
        x = x[1:]
        # ribalto l'array
        x.reverse()
        # aggiungo ogni elemento a tmp
        for i in x:
            tmp.cons(i)
            
        return tmp
    
    def __str__(self):
        """
        Chiamata da print per stampare una istanza
        """
        # la stringa inizia con [
        str_tmp = "["
        # se non e' vuota
        if self.node != None:
            # aggiungo il primo elemento convertito in stringa
            str_tmp = str_tmp + str(self.node[0])
            tmp = self.node[1]
            # finche' ci sono elementi
            while tmp != None:
                # li aggiungo convertiti in stringa
                str_tmp = str_tmp + "," + str(tmp[0])
                tmp = tmp[1]
        # la stringa termina con ]
        str_tmp = str_tmp + "]"
        return str_tmp
    

