#!/usr/bin/python
# coding: utf-8

import unittest
from timeit import *
from re import *
from Cane import *

class testCane(unittest.TestCase):

	def setUp(self):
		self.c = Cane("prova", 10, "razza")
		return

	def testObj(self):
		self.assertTrue(
			isinstance(self.c, Cane), 
			"L'oggetto non è un Cane"
		)

	def testMeth(self):
		self.assertTrue(
			callable(self.c.info),
			"Cane non ha il metodo info()"
		)
		self.assertTrue(
			callable(self.c.parla),
			"Cane non ha il metodo parla()"
		)
		self.assertTrue(
			callable(self.c.muove),
			"Cane non ha il metodo muove()"
		)
		self.assertTrue(
			callable(self.c.mangia),
			"Cane non ha il metodo mangia()"
		)
		self.assertTrue(
			callable(self.c.beve),
			"Cane non ha il metodo beve()"
		)
		self.assertTrue(
			callable(self.c.dorme),
			"Cane non ha il metodo dorme()"
		)
		self.assertTrue(
			callable(self.c.razza),
			"Cane non ha il metodo razza()"
		)
	
	def testinfo(self):
		self.assertEquals(
			self.c.razza("a"),
			self.c.info(),
			"Il metodo info() di Cane non funziona correttamente"
		)
		
	def testparla(self):
		self.assertEquals(
			self.c.parla(),
			"abbaia",
			"Il metodo parla() di Cane non funziona correttamente"
		)

	def testmuove(self):
		self.assertEquals(
			self.c.muove(),
			"corre",
			"Il metodo muove() di Cane non funziona correttamente"
		)

	def testmangia(self):
		self.assertEquals(
			self.c.mangia(),
			"mangia",
			"Il metodo mangia() di Cane non funziona correttamente"
		)

	def testbeve(self):
		self.assertEquals(
			self.c.beve(),
			"beve",
			"Il metodo beve() di Cane non funziona correttamente"
		)

	def testdorme(self):
		s = self.c.dorme(5)
		self.assertTrue(
			match("ha dormito per 5 unità di tempo", s) != None,
			"Il metodo dorme() di Cane non funziona correttamente"
		)

	def testrazza(self):
		self.assertRaises(
			TypeError,
			self.c.razza,
			1
		)
		self.assertRaises(
			ValueError,
			self.c.razza,
			""
		)
		self.assertEquals(
			self.c.razza("a"),
			self.c.razza(),
			"Il metodo razza() di Cane non funziona correttamente"
		)

	def tearDown(self):
		del self.c

	def suite(self):
		return unittest.TestLoader().loadTestsFromTestCase(testCane)

if __name__ == '__main__':
	unittest.main()
