#!/usr/bin/python
# coding: utf-8

import unittest
from timeit import *
from Animale import *

class testAnimale(unittest.TestCase):

	def setUp(self):
		self.a = Animale("prova", 10)
		return

	def testObj(self):
		self.assertTrue(
			isinstance(self.a, Animale), 
			"L'oggetto non è un Animale"
		)

	def testMeth(self):
		self.assertTrue(
			callable(self.a.info),
			"Animale non ha il metodo info()"
		)
		self.assertTrue(
			callable(self.a.parla),
			"Animale non ha il metodo parla()"
		)
		self.assertTrue(
			callable(self.a.muove),
			"Animale non ha il metodo muove()"
		)
		self.assertTrue(
			callable(self.a.mangia),
			"Animale non ha il metodo mangia()"
		)
		self.assertTrue(
			callable(self.a.beve),
			"Animale non ha il metodo beve()"
		)
		self.assertTrue(
			callable(self.a.dorme),
			"Animale non ha il metodo dorme()"
		)
		self.assertTrue(
			callable(self.a.nome),
			"Animale non ha il metodo nome()"
		)
		self.assertTrue(
			callable(self.a.eta),
			"Animale non ha il metodo eta()"
		)
		
	def testinfo(self):
		self.assertRaises(
			RuntimeError,
			self.a.info
		)

	def testparla(self):
		self.assertRaises(
			RuntimeError,
			self.a.parla
		)

	def testmuove(self):
		self.assertRaises(
			RuntimeError,
			self.a.muove
		)

	def testmangia(self):
		self.assertRaises(
			RuntimeError,
			self.a.mangia
		)

	def testbeve(self):
		self.assertRaises(
			RuntimeError,
			self.a.beve
		)

	def testdorme(self):
		self.assertRaises(
			TypeError,
			self.a.dorme,
			""
		)
		self.assertRaises(
			ValueError,
			self.a.dorme,
			-1
		)
		tm_obj = Timer(
			"a.dorme(1)",
			"from Animale import Animale; a = Animale('prova', 10)"
		)
		elapsed = tm_obj.timeit(10) / 10.0
		elapsed2 = self.a.dorme(1)

		self.assertAlmostEqual(
			elapsed,
			1.0,
			2,
			"Il metodo dorme() di Animale non dorme circa per un secondo"
		)
		self.assertEquals(
			elapsed2,
			1,
			"Il metodo dorme() di Animale non ritorna il numero di secondi corretto"
		)

	def testnome(self):
		self.assertRaises(
			TypeError,
			self.a.nome,
			1
		)
		self.assertRaises(
			ValueError,
			self.a.nome,
			""
		)
		self.assertEquals(
			self.a.nome("a"),
			self.a.nome(),
			"Il metodo nome() di Animale non funziona correttamente"
		)

	def testeta(self):
		self.assertRaises(
			TypeError,
			self.a.eta,
			""
		)
		self.assertRaises(
			ValueError,
			self.a.eta,
			-1
		)
		self.assertEquals(
			self.a.eta(15),
			self.a.eta(),
			"Il metodo eta() di Animale non funziona correttamente"
		)

	def tearDown(self):
		del self.a

	def suite(self):
		return unittest.TestLoader().loadTestsFromTestCase(testAnimale)

if __name__ == '__main__':
	unittest.main()
