#!/usr/bin/python
# coding: utf-8
"""
.. module:: Animale
   :platform: Unix, Windows
   :synopsis: Rappresentazione delle caratteristiche base di un animale. La classe Animale rappresenta le caratteristiche comuni a tutti gli animali.
   
.. moduleauthor:: Unimo <unimo@unimo.it>


"""


from time import sleep

class Animale:
	"""Classe madre di tutti gli animali.
	
	Si istanzia un oggetto di tipo Animale con il seguente
	statement:
	
	>>> a = Animale("nome", 10)

	Gli attributi caratteristici di un Animale sono il nome e l'età.
	Le azioni previste su un Animale sono: parla(), muove(), mangia(),
	beve(), dorme(), nome(), eta().
	"""
	def __init__(self, nome, eta):
		"""Costruttore della classe Animale.

        Args:
           nome (str): Nome dell'animale.

        Kwargs:
           eta (str): Eta dell'animale.

        """
		self.__nome = ""
		self.__eta = 0
		self.nome(nome)
		self.eta(eta)

	def info(self):
		"""Funzione di informazione sull'animale.
	
		   Non deve essere invocato su un oggetto di classe Animale, bensì su un oggetto di una sua sottoclasse.

	    """
		raise RuntimeError, "il metodo info() non è implementato nella classe Animale"

	def parla(self):
		"""Astrazione del parlato di un animale.

	       Non deve essere invocato su un oggetto di classe Animale, bensì su un oggetto di una sua sottoclasse.

	    """
		raise RuntimeError, "il metodo parla() non è implementato nella classe Animale"

	def muove(self):
		"""Astrazione del movimento di un animale.

	       Non deve essere invocato su un oggetto di classe Animale, bensì su un oggetto di una sua sottoclasse.

	    """
		raise RuntimeError, "il metodo muove() non è implementato nella classe Animale"

	def mangia(self):
		"""Astrazione del mangiare di un animale.

	       Non deve essere invocato su un oggetto di classe Animale, bensì su un oggetto di una sua sottoclasse.

	    """
		raise RuntimeError, "il metodo mangia() non è implementato nella classe Animale"

	def beve(self):
		"""Astrazione del bere di un animale.

	       Non deve essere invocato su un oggetto di classe Animale, bensì su un oggetto di una sua sottoclasse.

	    """
		raise RuntimeError, "il metodo beve() non è implementato nella classe Animale"

	def dorme(self, secondi = 1):
		"""Riposo di un animale.

	    Kwargs:
	       secondi (int): Secondi di riposo.

	    Returns:
	       int.  Il numero di secondi di riposo.

        Effetti collaterali: invoca una sleep(secondi).

	    """
		if (secondi != None):
			if (isinstance(secondi, int) == False):
				raise TypeError, "il numero di secondi deve essere un intero"
			if (secondi < 0):
				raise ValueError, "il numero di secondi deve essere non negativo"
		sleep(secondi)
		return secondi

	def nome(self, nome = None):
		"""Accessore dell'attributo nome.

	    Kwargs:
	       nome (str): nome.

	    Returns:
	       str.  Il nome dell'animale.

	    """
		if (nome != None):
			if (isinstance(nome, str) == False):
				raise TypeError, "il nome deve essere una stringa"
			if (nome == ""):
				raise ValueError, "il nome deve essere una stringa non vuota"
			self.__nome = nome
		return self.__nome

	def eta(self, eta = None):
		"""Accessore dell'attributo eta.

	    Kwargs:
	       eta (int): eta.

	    Returns:
	       int.  L'eta dell'animale.

	    """
		if (eta != None):
			if (isinstance(eta, int) == False):
				raise TypeError, "l'età deve essere un intero"
			if (eta < 0):
				raise ValueError, "l'età deve essere un intero non negativo"
			self.__eta = eta
		return self.__eta
