#!/usr/bin/python
# coding=utf8

# importiamo funzioni utili
from time import sleep
from random import random, shuffle

# importiamo le classi
from Animale import *
from Cane import *
from Cavallo import *
from Leone import *

# funzione per restituire un intero casuale
def caso(periodo):
	if periodo == None:
		periodo = 1
	return (int( random() * periodo ))

# lista degli animali
zoo = []

# possibili nomi degli animali
nomi_cani = [ "Lessie", "Rocky", "Laika", "Poldo", "Fuffi" ]
nomi_cavalli = [ "Varenne", "Freccia", "Spirit", "Stella", "Strike" ]
nomi_leoni = [ "Leo", "Leonida", "Principessa", "Leone", "Re", "Simba" ]

# possibili caratteristiche degli animanli
razze_cani = [ "pastore", "levriero", "maremmano", "schnauzer", "barboncino" ]
mantelli_cavalli = [ "nero", "baio", "pezzato", "fulvo" ]
pesi_leoni = range(150,225)

# numero di animali
num_cani = int(random() * 9.0) + 1
num_cavalli = int(random() * 9.0) + 1
num_leoni = int(random() * 9.0) + 1

# eta' massime
max_eta_cane = 20
max_eta_cavallo = 25
max_eta_leone = 20

# crea i cani
for i in range(num_cani):
	zoo.append(
		Cane(
			nome = nomi_cani[caso(len(nomi_cani))],
			eta = caso(max_eta_cane) + 1,
			razza = razze_cani[caso(len(razze_cani))]
		)
	)

# crea i cavalli
for i in range(num_cavalli):
	zoo.append(
		Cavallo(
			nome = nomi_cavalli[caso(len(nomi_cavalli))],
			eta = caso(max_eta_cavallo) + 1,
			mantello = mantelli_cavalli[caso(len(mantelli_cavalli))]
		)
	)

# crea i leoni
for i in range(num_leoni):
	zoo.append(
		Leone(
			nome = nomi_leoni[caso(len(nomi_leoni))],
			eta = caso(max_eta_leone) + 1,
			peso = pesi_leoni[caso(len(pesi_leoni))]
		)
	)

# mischia tutti gli animali
shuffle(zoo)

# usiamo gli oggetti animali
for i in range(20):
	# scegliamo un animale a caso
	id_zoo = caso(len(zoo))
	# scegliamo una azione a caso
	id_azione = caso(5) + 1
	# bestia fa riferimento all'animale scelto
	bestia = zoo[id_zoo]

	# costruiamo la frase
	frase = bestia.nome()
	frase = frase + " (eta' "
	frase = frase + str(bestia.eta())
	frase = frase + " anni, "
	frase = frase + bestia.info()
	frase = frase + ") "

	# e effettuiamo l'azione
	if id_azione == 1:
		frase = frase + bestia.parla()
	elif id_azione == 2:
		frase = frase + bestia.muove()
	elif id_azione == 3:
		frase = frase + bestia.mangia()
	elif id_azione == 4:
		frase = frase + bestia.beve()
	elif id_azione == 5:
		periodo = bestia.dorme(caso(5) + 1)
		frase = frase + "ha dormito per "
		frase = frase + str(periodo)
		frase = frase + " unita' di tempo"

	print frase
	# sospensione per 1 secondo tra un animale e l'altro
	sleep(1)

