#!/usr/bin/python
# coding: utf-8

import sys
import unittest
from testRettangolo import *
from testCerchio import *

# Definisco una suite di test per ciascuno
# dei moduli che intendo verificare
# - testRettangolo
# - testCerchio
#
# NB: non esiste un metodo standard per la definizione
# di metodi di classe. E' necessario instanziare un
# oggetto di tipo testXYZ per poter eseguire il metodo
# suite(). Sfortunatamente, la classe testXYZ() richiede
# una stringa come parametro del costruttore (per specificare
# il metodo da eseguire). Usiamo dunque un metodo a caso
# (qui, testObj, ma potrebbe essere qualunque altro della
# classe testXYZ).
ts_rettangolo = testRettangolo("testObj").suite()
ts_cerchio = testCerchio("testObj").suite()

# Istanzio un oggetto di tipo TestSuite
ts = unittest.TestSuite()

# Inserisco nell'oggetto TestSuite le test suite
# dei singoli moduli che intendo eseguire
ts.addTest(ts_rettangolo)
ts.addTest(ts_cerchio)

# Istanzio un oggetto di tipo TextTestRunner, che eseguirà
# la test suite ts con l'opportuna configurazione
# - scrittura su stdout
# - livello di verbosità pari a 2
trun = unittest.TextTestRunner(sys.stdout, verbosity = 2)

# Eseguo la suite di test
res = trun.run(ts)
