#!/usr/bin/python
# coding: utf-8

import unittest
from Rettangolo import *

def suite(self):
	l = unittest.TestLoader()
	s = l.loadTestsFromTestCase(testRettangolo)
	return s

class testRettangolo(unittest.TestCase):

	def setUp(self):
		self.r = Rettangolo(10.0, 20.0)

	def testObj(self):
		self.assertTrue(
			isinstance(self.r, Rettangolo), 
			"r non è un Rettangolo"
		)

	def testMeth(self):
		self.assertTrue(
			callable(self.r.base),
			"r non ha il metodo base"
		)
		self.assertTrue(
			callable(self.r.altezza),
			"r non ha il metodo altezza"
		)
		self.assertTrue(
			callable(self.r.perimetro),
			"r non ha il metodo perimetro"
		)
		self.assertTrue(
			callable(self.r.area),
			"r non ha il metodo area"
		)

	def testbase(self):
		self.assertRaises(
			TypeError,
			self.r.base,
			""
		)
		self.assertRaises(
			ValueError,
			self.r.base,
			-1.0
		)

		self.r.base(2.0)
		self.assertEqual(
			self.r.base(),
			 2.0,
			 "la base di r non è recuperata correttamente"
		)

	def testaltezza(self):
		self.assertRaises(
			TypeError,
			self.r.altezza,
			""
		)
		self.assertRaises(
			ValueError,
			self.r.altezza,
			-1.0
		)

		self.r.altezza(4.0)
		self.assertEqual(
			self.r.altezza(),
			 4.0,
			 "l'altezza di r non è recuperata correttamente"
		)

	def testperimetro(self):
		self.r.base(5.0)
		self.r.altezza(10.0)
		self.assertEqual(
			self.r.perimetro(),
			30.0,
			"il perimetro di r non è calcolato correttamente"
		)

	def testarea(self):
		self.r.base(5.0)
		self.r.altezza(10.0)
		self.assertEqual(
			self.r.area(),
			50.0,
			"l'area di r non è calcolato correttamente"
		)

	def tearDown(self):
		del self.r

if __name__ == '__main__':
	unittest.main()
