#!/usr/bin/python
# coding: utf-8

import sys
import unittest
from testRettangolo import *
from testCerchio import *

# Definisco una suite di test per ciascuno
# dei moduli che intendo verificare
# - testRettangolo
# - testCerchio
ts_rettangolo = unittest.TestLoader().loadTestsFromTestCase(testRettangolo)
ts_cerchio = unittest.TestLoader().loadTestsFromTestCase(testCerchio)

# Istanzio un oggetto di tipo TestSuite
ts = unittest.TestSuite()

# Inserisco nell'oggetto TestSuite le test suite
# dei singoli moduli che intendo eseguire
ts.addTest(ts_rettangolo)
ts.addTest(ts_cerchio)

# Istanzio un oggetto di tipo TextTestRunner, che eseguirà
# la test suite ts con l'opportuna configurazione
# - scrittura su stdout
# - livello di verbosità pari a 2
trun = unittest.TextTestRunner(sys.stdout, verbosity = 2)

# Eseguo la suite di test
res = trun.run(ts)
