#!/usr/bin/python
# coding: utf-8
"""Rappresentazione delle caratteristiche base di un animale.

La classe Animale rappresenta le caratteristiche comuni a tutti
gli animali.
"""

from time import sleep

class Animale:
	"""Classe madre di tutti gli animali.
	
	Si istanzia un oggetto di tipo Animale con il seguente
	statement:
	
		a = Animale("nome", 10)

	Gli attributi caratteristici di un Animale sono il nome e l'età.
	Le azioni previste su un Animale sono: parla(), muove(), mangia(),
	beve(), dorme(), nome(), eta().
	"""
	def __init__(self, nome, eta):
		self.__nome = nome
		self.__eta = eta

	def parla(self):
		""" parla() - astrazione del parlato di un animale

		Parametri in ingresso: nessuno
		Valore di uscita: nessuno
		Effetti collaterali: non deve essere invocato su un oggetto
		di classe Animale, bensì su un oggetto di una sua sottoclasse.
		"""
		print "il metordo parla() non e' implementato nella classe Animale"

	def muove(self):
		""" muove() - astrazione del movimento di un animale

		Parametri in ingresso: nessuno
		Valore di uscita: nessuno
		Effetti collaterali: non deve essere invocato su un oggetto
		di classe Animale, bensì su un oggetto di una sua sottoclasse.
		"""
		print "il metordo muove() non e' implementato nella classe Animale"

	def mangia(self):
		""" mangia() - astrazione del mangiare di un animale

		Parametri in ingresso: nessuno
		Valore di uscita: nessuno
		Effetti collaterali: non deve essere invocato su un oggetto
		di classe Animale, bensì su un oggetto di una sua sottoclasse.
		"""
		print "il metodo mangia() non e' implementato nella classe Animale"

	def beve(self):
		""" beve() - astrazione del bere di un animale

		Parametri in ingresso: nessuno
		Valore di uscita: nessuno
		Effetti collaterali: non deve essere invocato su un oggetto
		di classe Animale, bensì su un oggetto di una sua sottoclasse.
		"""
		print "il metodo beve() non e' implementato nella classe Animale"

	def dorme(self, secondi):
		""" dorme([secondi]) - riposo di un animale

		Parametri in ingresso: secondi di riposo (opzionale)
		Valore di uscita: il numero di secondi di riposo
		Effetti collaterali: invoca una sleep(secondi)
		"""
		t = 1
		if (secondi != None):
			t = secondi
		sleep(t)
		return t

	def nome(self, nome = None):
		""" nome([nome]) - accessore dell'attributo nome

		Parametri in ingresso: nome (opzionale)
		Valore di uscita: una stringa contenente il nome dell'animale
		Effetti collaterali: imposta il nome se presente come argomento
		"""
		if (nome != None):
			self.__nome = nome
		return self.__nome

	def eta(self, eta = None):
		""" eta([eta]) - accessore dell'attributo età

		Parametri in ingresso: eta (opzionale)
		Valore di uscita: un intero contenente l'età dell'animale
		Effetti collaterali: imposta l'età se presente come argomento
		"""
		if (eta != None):
			self.__eta = eta
		return self.__eta
