#!/usr/bin/perl

use warnings;
use strict;
use diagnostics;

use Getopt::Long;
use Chart::Lines;

sub usage() {
	printf "Usage: $0 [--help] [--output-file=<string>]\n"
}

my $help = 0;
my $output_file = "";

GetOptions(
	"help" => \$help,
	"output-file=s" => \$output_file
);

if ($help) {
	usage();
	exit();
}

$output_file ne "" or $output_file = "sample_diagram.png";

my @x = ( 10, 20, 30, 40, 50 );
my @y1 = ( 10, 20, 30, 40, 50 );
my @y2 = ( 20, 40, 60, 80, 100 );
my @data = ( \@x, \@y1, \@y2 );

my $obj = Chart::Lines->new(600, 400);

$obj->set(
	"title" => "Diagramma cartesiano"
);
$obj->png( $output_file, \@data );
