#!/usr/bin/ruby

3.times {puts "Inside the times method."}
['lions', 'tigers', 'bears'].each {|item| puts item}

animals = ['lions', 'tigers', 'bears'].collect {|item| item.upcase}
puts animals.join(" and ") + " oh, my."

tax = 0.08
prices = [4.45, 6.34, 3.78]
tax_table = prices.collect {|price| {:price => price, :tax => price * tax}}
tax_table.collect {|item| puts "Price: #{item[:price]}    Tax: #{item[:tax]}"}

def paragraph 
  puts "A good paragraph should have a topic sentence."
  yield
  puts "This generic paragraph has a topic, body, and conclusion."
end

paragraph {puts "This is the body of the paragraph."}
